% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyfilter.r
\name{define_filters}
\alias{define_filters}
\title{Define the set of interdependent filters}
\usage{
define_filters(input, react_id, filters, data)
}
\arguments{
\item{input}{The input object provided as an argument to the server function.}

\item{react_id}{Object ID/input slot of the \code{reactable} which the
filters will be linked to.}

\item{filters}{A named character vector with the column names of the
dataframe that will be filtered. The \emph{names} of the vector elements
are the object IDs/input slots of the respective \code{selectizeInput()}
widgets used as filters.}

\item{data}{The (unfiltered) dataframe presented in the \code{reactable}.}
}
\value{
No return value.
}
\description{
Installs the filters and binds them to the \code{reactable}
  widget and the dataframe presented in the \code{reactable}.

  \code{define_filters()} needs to be called in the server function of any
  shiny app using \code{shinyfilter}.
}
\details{
For a full example of a shiny app using \code{shinyfilter} please
  call up the help for \code{\link{update_filters}()}. See the
  \code{README.md} file or the GitHub repo on
  \href{https://github.com/jsugarelli/shinyfilter}{https://github.com/jsugarelli/shinyfilter}
  for a comprehensive \code{shinyfilter} tutorial.
}
