% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc_styles.R
\name{copy_styles}
\alias{copy_styles}
\title{Copy Styles from a Source to a Destination}
\usage{
copy_styles(
  from,
  from_layer = NULL,
  to,
  database = NULL,
  schema = "public",
  to_layers = NULL
)
}
\arguments{
\item{from}{A data source for the input style. This can be:
- A string representing the path to a GeoPackage file.
- A `DBI` database connection object to a PostGIS database, created using [RPostgres::dbConnect()].}

\item{from_layer}{Character (optional). Name of the layer in the source to copy the style from.
If not provided, the function will use the first layer in the source with a defined style.}

\item{to}{A data destination for the output styles. This can be:
- A string representing the path to a GeoPackage file.
- A `DBI` database connection object to a PostGIS database, created using [RPostgres::dbConnect()].}

\item{database}{Character (optional). Name of the destination PostGIS database
(required if the destination is a PostGIS connection object).}

\item{schema}{Character. Schema in the destination PostGIS database where the styles will be applied.
Default is "public".}

\item{to_layers}{Character vector (optional). Names of the layers in the destination where the style
will be applied. If not provided, the style will be applied to all layers in the destination.}
}
\value{
The updated `layer_styles` table, returned invisibly.
}
\description{
Copies layer styles from a source (GeoPackage or PostGIS database) to a destination
(GeoPackage or PostGIS database). The source and destination can be specified flexibly,
and the function supports copying styles to multiple layers in the destination.
}
\examples{
# Ex1:
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
layer_data <- sf::st_read(source_gpkg, layer = "clc", quiet = TRUE)

dest_gpkg <- tempfile(fileext = ".gpkg")
sf::st_write(layer_data, dest_gpkg, layer = "clc", quiet = TRUE)

copy_styles(from = source_gpkg, to = dest_gpkg)

\dontrun{
# Ex2:
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
conn <- DBI::dbConnect(
  RPostgres::Postgres(),
  dbname = "mydb",
  host = "localhost",
  user = "user",
  password = "password"
)

copy_styles(
  from = source_gpkg,
  to = conn,
  database = "mydb",
  schema = "public",
  to_layers = c("layer1", "layer2"),
)

DBI::dbDisconnect(conn)
}
}
\seealso{
Other style functions: 
\code{\link{get_layer_categories}()}
}
\concept{style functions}
