% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_aggregate_rasters.R
\name{aggregate_rasters}
\alias{aggregate_rasters}
\title{Aggregate Rasters in a Folder}
\usage{
aggregate_rasters(dir, out_dir, factor = 2)
}
\arguments{
\item{dir}{A string specifying the input folder containing raster files.}

\item{out_dir}{A string specifying the output folder where the aggregated
rasters will be saved.}

\item{factor}{An integer specifying the aggregation factor (default is 2).}
}
\value{
A character vector with the paths to the processed raster files.
}
\description{
Aggregates all raster files (`.tif` or `.jp2`) in a specified folder by the
given factor and saves the resulting files in an output folder.
}
\details{
If the output folder does not exist, it creates it.
}
\examples{
temp_dir <- tempdir()
input_dir <- system.file("extdata", "mdt", package = "sigugr")

result_files <- aggregate_rasters(input_dir, temp_dir, factor = 4)

}
\seealso{
Other transform raster functions: 
\code{\link{compose_raster}()}
}
\concept{transform raster functions}
