% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_layer.R
\name{clip_layer}
\alias{clip_layer}
\title{Clip a Vector Layer with a Polygon}
\usage{
clip_layer(vector, polygon)
}
\arguments{
\item{vector}{An `sf` object representing the vector layer to be clipped.}

\item{polygon}{An `sf` object representing the polygon layer used for clipping.}
}
\value{
An `sf` object containing the features of the input `vector` that intersect with the `polygon`.
The output will be in the CRS of the `polygon`, and it will retain all attributes of the input `vector`.
}
\description{
Clips a vector layer using a polygon layer. It handles CRS transformations automatically
if necessary, ensuring the output is in the same CRS as the input polygon.
}
\examples{
gpkg_path <- system.file("extdata", "clc.gpkg", package = "clc")

clc <- sf::st_read(gpkg_path, layer = "clc", quiet = TRUE)
lanjaron <- sf::st_read(gpkg_path, layer = "lanjaron", quiet = TRUE)

clc_clipped <- clip_layer(clc, lanjaron)

}
\seealso{
Other clip functions: 
\code{\link{clip_multipoligon}()},
\code{\link{clip_raster}()},
\code{\link{generate_bbox}()}
}
\concept{clip functions}
