% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_publish_layer_set.R
\name{publish_layer_set}
\alias{publish_layer_set}
\alias{publish_layer_set.geoserver}
\title{Publish a Vector Layer Set to GeoServer}
\usage{
publish_layer_set(gso, source, layers)

\method{publish_layer_set}{geoserver}(gso, source, layers = NULL)
}
\arguments{
\item{gso}{An object of class `geoserver` containing GeoServer connection details.}

\item{source}{A valid connection to a PostGIS database (`RPostgres` connection object).}

\item{layers}{An optional character vector of layer names to check and publish.
If `NULL` (default), all vector geometry layers in the source will be published.}
}
\value{
An integer:
\itemize{
  \item \code{0} if the operation was successful for all layers.
  \item \code{1} if an error occurred.
}
}
\description{
Publishes a vector layer set to GeoServer. The layer source must have previously
been defined as a GeoSever datastore.
}
\details{
Iterates over a set of layers in a source database, checking whether each layer
contains vector geometry. If the layer meets the criteria, it is published. If the
`layers` parameter is `NULL`, the function will publish all layers with vector
geometry in the source.

Prints an appropriate messages indicating success or failure.
}
\examples{
\dontrun{
gso <- geoserver(
  url = "http://localhost:8080/geoserver",
  user = "admin",
  password = "geoserver",
  workspace = "sigugr_test"
)

gso <- gso |>
  register_datastore_postgis(
    "sigugr-postgis",
    db_name = 'sigugr_example',
    host = 'localhost',
    port = 5432,
    db_user = 'user',
    db_password = 'password',
    schema = "public"
  )

source <- RPostgres::dbConnect(
  RPostgres::Postgres(),
  dbname = 'mydb',
  host = 'localhost',
  port = '5432',
  user = 'user',
  password = 'password'
)

gso |>
  publish_layer_set(source)
}
}
\seealso{
Other publish to GeoServer: 
\code{\link{geoserver}()},
\code{\link{publish_bands}()},
\code{\link{publish_layer}()},
\code{\link{publish_raster}()},
\code{\link{register_datastore_postgis}()}
}
\concept{publish to GeoServer}
