% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_register_postgis.R
\name{register_datastore_postgis}
\alias{register_datastore_postgis}
\alias{register_datastore_postgis.geoserver}
\title{Register a PostGIS Database as a DataStore in GeoServer}
\usage{
register_datastore_postgis(
  gso,
  datastore,
  db_name,
  host,
  port,
  db_user,
  db_password,
  schema
)

\method{register_datastore_postgis}{geoserver}(
  gso,
  datastore,
  db_name,
  host,
  port = 5432,
  db_user,
  db_password,
  schema = "public"
)
}
\arguments{
\item{gso}{An object of class `geoserver` containing GeoServer connection details.}

\item{datastore}{A character string. The name of the datastore to be created.}

\item{db_name}{A character string. The name of the PostGIS database.}

\item{host}{A character string. The database host.}

\item{port}{An integer. The database port (default: 5432).}

\item{db_user}{A character string. The database username.}

\item{db_password}{A character string. The database password.}

\item{schema}{A character string. The database schema (default: "public").}
}
\value{
An object of class `geoserver` or NULL if an error occurred.
}
\description{
Registers a PostGIS database as a `datastore` in a specified GeoServer workspace.
}
\details{
If the `datastore` has already been registered previously, there is no need to specify the
database connection. For subsequent operations, that `datastore` will be used.

In any case, prints an appropriate message.
}
\examples{
\dontrun{
gso <- geoserver(
  url = "http://localhost:8080/geoserver",
  user = "admin",
  password = "geoserver",
  workspace = "sigugr_test"
)

gso <- gso |>
  register_datastore_postgis(
    "sigugr-postgis",
    db_name = 'sigugr_example',
    host = 'localhost',
    port = 5432,
    db_user = 'user',
    db_password = 'password',
    schema = "public"
  )
}

}
\seealso{
Other publish to GeoServer: 
\code{\link{geoserver}()},
\code{\link{publish_bands}()},
\code{\link{publish_layer}()},
\code{\link{publish_layer_set}()},
\code{\link{publish_raster}()}
}
\concept{publish to GeoServer}
