% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-tree-level.R
\name{silv_tree_basal_area}
\alias{silv_tree_basal_area}
\title{Calculates Basal Area}
\usage{
silv_tree_basal_area(diameter, units = "cm")
}
\arguments{
\item{diameter}{Numeric vector of diameters or diameter classes}

\item{units}{The units of the diameter (one of \code{mm}, \code{cm}, \code{dm}, or \code{m})}
}
\value{
A numeric vector
}
\description{
Calculates Basal Area in square meters.
}
\details{
The function uses the next formula:

\eqn{g = \frac{\pi}{40000} \cdot D^2}

where g is the basal area in \eqn{m^2} of one tree, and D is the diameter in \code{cm}.

If you want to calculate the basal area for a group of trees (e.g. per hectares),
please use \code{\link[=silv_stand_basal_area]{silv_stand_basal_area()}}
}
\examples{
## calculate individual basal area
silv_tree_basal_area(c(23, 11, 43.5, 94))
}
\seealso{
\code{\link[=silv_stand_basal_area]{silv_stand_basal_area()}}
}
