% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_LSAE.R
\name{sample_LSAE}
\alias{sample_LSAE}
\title{Sample Locus Specific Amplification Efficiency (LSAE) according to prior}
\usage{
sample_LSAE(LSAE_variance, locus_names)
}
\arguments{
\item{LSAE_variance}{Numeric. See \link{gf_configuration} for an example.}

\item{locus_names}{Character vector.}
}
\value{
Named numeric with LSAEs for each locus (names).
}
\description{
Sample Locus Specific Amplification Efficiency (LSAE) according to prior
}
\details{
In the Bright et al. log normal model, the expected peak height
includes a multiplicative factor for the locus (marker). These factors are
called the LSAEs (Locus Specific Amplification Efficiencies). In the model,
the prior for the log10 of LSAE is normal with mean 0. The variance
can be specified.
}
\examples{
gf <- gf_configuration()
lsae <- sample_LSAE(LSAE_variance = gf$log_normal_settings$LSAE_variance_prior,
                     locus_names = gf$autosomal_markers)

# the barplot shows that some loci amplify better than others
barplot(lsae, las=2)
}
