% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_mixtures_fixed_parameters.R
\name{sample_mixtures_fixed_parameters}
\alias{sample_mixtures_fixed_parameters}
\title{Sample mixtures with known genotypes and fixed parameters}
\usage{
sample_mixtures_fixed_parameters(
  genotypes,
  parameter_summary,
  model_settings,
  results_directory,
  seed,
  tag = "simulation",
  silent = FALSE
)
}
\arguments{
\item{genotypes}{List of contributor genotypes. See \link{sample_contributor_genotypes}.}

\item{parameter_summary}{DataFrame with parameters for each sample.}

\item{model_settings}{List. Passed to the sample_model function.}

\item{results_directory}{(optionally) Character with path to directory where results are written to disk.}

\item{seed}{(optionally) Integer seed value that can be used to get reproducible runs. If results are written to disk, the 'Run details.txt' file will contain a seed that can be used for reproducing the result.}

\item{tag}{Character. Used for sub directory name when results_directory is provided.}

\item{silent}{Logical. If TRUE, then no message will be printed about where the output (if any) was written to disk.}
}
\value{
If \code{results_directory} is provided, this function has the side effect of writing results to disk.

Return value is a list with simulation results:\itemize{
\item \code{call} matched call
\item \code{smash} DataFrame with all samples in SMASH format (see \link{SMASH_to_wide_table})
\item \code{samples} Detailed results for each sample
\item \code{parameter_summary} DataFrame with parameters for each sample
}
}
\description{
Sample mixtures with known genotypes and fixed parameters
}
\examples{
# simulate autosomal samples with fixed parameters (from csv) and refs (from csv)
parameter_summary <- utils::read.csv(system.file(
"extdata","Example_2p_Parameter_Summary.csv",
package = "simDNAmixtures"))

gf <- gf_configuration()

filename_refs <- system.file("extdata","Example_References_DB.csv",
                            package = "simDNAmixtures")
db_refs <- utils::read.csv(filename_refs, check.names = FALSE)

genotypes <- simDNAmixtures:::.wide_references_to_allele_tables(db_refs)

samples <- sample_mixtures_fixed_parameters(genotypes = genotypes,
                                           parameter_summary = parameter_summary,
                                           model_settings = gf$log_normal_bwfw_settings,
                                           seed = 1)
}
\seealso{
\link{sample_mixtures}
}
