% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_code.R
\name{generate_fake_data}
\alias{generate_fake_data}
\title{Make fake data for testing purposes.}
\usage{
generate_fake_data(
  t_min = -40,
  t_max = 9,
  t0 = 0,
  rho = 0.5,
  sd.omega = 1,
  coef_line = c(20, 0.05),
  coef_q = c(1, 0, -1, 0),
  coef_temp = 0.1,
  coef_sin = c(0, 0),
  coef_tx = c(0, 0.25, 5)
)
}
\arguments{
\item{t_min}{Index of first month}

\item{t_max}{Index of last month}

\item{t0}{Last pre-policy time point}

\item{rho}{Autocorrelation}

\item{sd.omega}{Standard deviation of the true residual}

\item{coef_line}{Intercept and slope of the main trendline (list of 2).}

\item{coef_q}{Coefficients for the four quarters (list of 4).}

\item{coef_temp}{Coefficient for temperature.}

\item{coef_sin}{Coefficents for sin and cos features (list of 2)}

\item{coef_tx}{Coefficient for treatment post-policy (list of 3, initial
offset, initial slope, additional slope past 12 months).  Treatment is a
piecewise linear function.}
}
\value{
A \code{data.frame} having \code{month} , \code{temperature} ,
  \code{sin.m} , \code{cos.m} , \code{Q1}, \code{Q2} , \code{Q3}, \code{Q4},
  \code{post} , \code{Ystr0} , \code{Ystr} , \code{Y}
}
\description{
Defaults have heavy seasonality, and an extra bump in impact kicks in at 12
months post-policy.
}
\examples{
fdat = generate_fake_data(-100,100, rho = 0.95, coef_q=c(0,0,0,0), coef_temp = 0)
plot( fdat$month, fdat$Y, type="l" )
fdat2 = generate_fake_data(-100, 100, rho = 0.0, coef_q=c(0,0,0,0), coef_temp = 0)
plot( fdat$month, fdat2$Y, type="l" )
}
