% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ProjectToHurwitz}
\alias{ProjectToHurwitz}
\title{Project Matrix to Hurwitz Stability}
\usage{
ProjectToHurwitz(x, margin = 0.001)
}
\arguments{
\item{x}{Numeric square matrix.}

\item{margin}{Positive numeric.
Target buffer inside the Hurwitz region;
the result satisfies
\eqn{\max \Re\{\lambda_i(x^\star)\} \le -\text{margin}}
(default \code{1e-3}).}
}
\value{
A numeric matrix of the same dimensions as \code{x},
shifted if necessary to satisfy the Hurwitz stability constraint.
}
\description{
Shifts a square matrix left on the real axis
so that its spectral abscissa (maximum real part of the eigenvalues)
is strictly less than \code{-margin}.
This is useful for ensuring that continuous-time drift matrices
(e.g. in linear SDEs/state-space models) are Hurwitz-stable.
If the matrix already satisfies the margin,
it is returned unchanged.
}
\details{
The projection is performed by subtracting a multiple of the identity:
\deqn{x^\star = x - (\alpha + \text{margin}) I,}
where \eqn{\alpha = \max \Re\{\lambda_i(x)\}} is the spectral abscissa.
}
\examples{
# Unstable (spectral abscissa >= 0):
x <- matrix(
  data = c(
    0.10, -0.40,
    0.50, 0.20
  ),
  nrow = 2
)
SpectralAbscissa(x = x) # >= 0
SpectralAbscissa(x = ProjectToHurwitz(x = x)) # <= -1e-3 (default margin)

# Already Hurwitz-stable is returned unchanged up to numerics:
x <- matrix(
  data = c(
    -0.50, -0.20,
     1.00, -0.30
  ),
  nrow = 2
)
SpectralAbscissa(x = x) # < 0
identical(ProjectToHurwitz(x = x), x)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
\keyword{stability}
