% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-ssm-intercept-eta.R
\name{SSMInterceptEta}
\alias{SSMInterceptEta}
\title{Intercept from
Steady-State Mean Vector for the
Latent Variables in the
State Space Model}
\usage{
SSMInterceptEta(beta, mean_eta)
}
\arguments{
\item{beta}{Numeric matrix.
Transition matrix relating the values of the latent variables
at the previous to the current time point
(\eqn{\boldsymbol{\beta}}).}

\item{mean_eta}{Numeric vector.
Steady-state mean vector
of the latent variables
\eqn{\mathrm{Mean} \left( \boldsymbol{\eta} \right)}.}
}
\description{
The intercept vector
for the latent variables
in the state space model
\eqn{\boldsymbol{\alpha}}
is given by
\deqn{
  \boldsymbol{\alpha}
  =
  \mathrm{Mean} \left( \boldsymbol{\eta} \right) -
  \boldsymbol{\beta} \mathrm{Mean} \left( \boldsymbol{\eta} \right)
}
where
\eqn{\boldsymbol{\beta}}
is the transition matrix relating the values of the latent variables
at the previous to the current time point,
\eqn{\mathrm{Mean} \left( \boldsymbol{\eta} \right)}
is the steady-state mean vector
for the latent variables.
}
\examples{
beta <- matrix(
  data = c(
    0.7, 0.5, -0.1,
    0.0, 0.6, 0.4,
    0.0, 0.0, 0.5
  ),
  nrow = 3
)
alpha <- rep(x = 1, times = 3)
mean_eta <- SSMMeanEta(
  beta = beta,
  alpha = alpha
)
SSMInterceptEta(
  beta = beta,
  mean_eta = mean_eta
)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMInterceptY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
