% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recomb_last_gen.R
\name{recomb_last_gen}
\alias{recomb_last_gen}
\title{Draw recombination breaks for autosomes for last generation of a pedigree}
\usage{
recomb_last_gen(founders, fam, ids, missing_vals = c("", 0))
}
\arguments{
\item{founders}{The named list of founders with their chromosomes.
For unstructured founders, initialize with \code{\link[=recomb_init_founders]{recomb_init_founders()}}.
Each element of this list is a diploid individual, which is a list with two haploid individuals named \code{pat} and \code{mat}, each of which is a list of chromosomes (always identified by number, but may also be named arbitrarily), each of which is a data.frame/tibble with implicit ranges (\code{posg} is end coordinates in cM; start is the end of the previous block, zero for the first block) and ancestors \code{anc} as strings.
For true founders each chromosome may be trivial (each chromosome is a single block with ID equal to itself but distinguishing maternal from paternal copy), but input itself can be recombined (for iterating).
This list must have names that identify each founder (matching codes in \code{fam$id}).
Individuals may be in a different order than \code{fam$id}.
Extra individuals in \code{founders} but absent in \code{fam$id} will be silently ignored.}

\item{fam}{The pedigree data.frame, in plink FAM format.
Only columns \code{id}, \code{pat}, and \code{mat} are required.
\code{id} must be unique and non-missing.
Founders must be present, and their \code{pat} and \code{mat} values must be missing (see below).
Non-founders must have both their parents be non-missing.
Parents must appear earlier than their children in the table.}

\item{ids}{A list containing vectors of IDs for each generation.
All these IDs must be present in \code{fam$id}.
If IDs in \code{fam} and \code{ids} do not fully agree, the code processes the IDs in the intersection, which is helpful when \code{fam} is pruned but \code{ids} is the original (larger) set.}

\item{missing_vals}{The list of ID values treated as missing.
\code{NA} is always treated as missing.
By default, the empty string ('') and zero (0) are also treated as missing (remove values from here if this is a problem).}
}
\value{
The list of individuals with recombined chromosomes of the last generation (the intersection of \code{ids[ length(ids) ]} and \code{fam$id}), in the same format as \code{founders} above.
The names of this list are last-generation individuals in the order that they appear in \code{fam$id}.
}
\description{
A wrapper around the more general \code{\link[=recomb_fam]{recomb_fam()}}, specialized to save memory when only the last generation is desired (\code{\link[=recomb_fam]{recomb_fam()}} returns recombination blocks for the entire pedigree).
This function assumes that generations are non-overlapping (met by the output of \code{\link[=sim_pedigree]{sim_pedigree()}}), in which case each generation \code{g} can be drawn from generation \code{g-1} data only.
That way, only two consecutive generations need be in memory at any given time.
The partitioning of individuals into generations is given by the \code{ids} parameter (again matches the output of \code{\link[=sim_pedigree]{sim_pedigree()}}).
}
\examples{
# A small pedigree, two parents and two children.
# A minimal fam table with the three required columns.
# Note "mother" and "father" have missing parent IDs, while children do not
library(tibble)
fam <- tibble(
  id = c('father', 'mother', 'child', 'sib'),
  pat = c(NA, NA, 'father', 'father'),
  mat = c(NA, NA, 'mother', 'mother')
)
# need an `ids` list separating the generations
ids <- list( c('father', 'mother'), c('child', 'sib') )

# initialize parents with this other function
# simulate three chromosomes with these lengths in cM
lengs <- c(50, 100, 150)
founders <- recomb_init_founders( ids[[1]], lengs )

# draw recombination breaks for the children
inds <- recomb_last_gen( founders, fam, ids )

}
\seealso{
Plink FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#fam}
}
