% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recomb_map_fix_ends_chr.R
\name{recomb_map_fix_ends_chr}
\alias{recomb_map_fix_ends_chr}
\title{Extrapolate and shift recombination map of one chromosome to ends}
\usage{
recomb_map_fix_ends_chr(map, pos_length, pos_delta = 10000000L)
}
\arguments{
\item{map}{A tibble with two columns: \code{pos} position in base pairs, and \code{posg} position in centiMorgans (cM).}

\item{pos_length}{The length of the chromosome in base pairs.}

\item{pos_delta}{The size of the window used to extrapolate recombination rates.}
}
\value{
The extrapolated recombination map, shifted so the first non-trivial position maps to the genetic distance expected from the extrapolated rate at the beginning, then added a first trivial position (\verb{pos=1, posg=0}) and final basepair position at length of chromosome and expected genetic position from end extrapolation.
}
\description{
Given an existing recombination map and a chromosome length in base pairs, extrapolates the map to ensure all positions are covered, and shifts to ensure position one in basepairs corresponds to position 0 in genetic position.
Recombination rates are extrapolated from the first and last 10Mb of data by default (separately per end).
Therefore fixes the fact that common maps start genetic position zero at base pair position \verb{>> 1} and do not extend to ends (some SNPs from modern projects fall out of range without fixes).
}
\examples{
library(tibble)
# create a toy recombination map with at least 10Mb at each end
map <- tibble(
    pos  = c( 3L,  15L, 100L, 120L ) * 1e6L,
    posg = c(  0, 10.4, 90.1,  110 )
)
# and length
pos_length <- 150L * 1e6L

# apply function!
map_fixed <- recomb_map_fix_ends_chr( map, pos_length )
# inspect
map_fixed

}
\seealso{
\code{\link[=recomb_map_simplify_chr]{recomb_map_simplify_chr()}} to simplify recombination maps to a desired numerical accuracy.
}
