% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multigraphs.R
\name{is_loopy}
\alias{is_loopy}
\title{Is this a loopy graph?}
\usage{
is_loopy(graph)
}
\arguments{
\item{graph}{The input graph.}
}
\value{
Logical scalar.
}
\description{
A loopy graph has at least one loop edge: an edge from a vertex to
itself.
}
\examples{
G <- graph(list(A = c("A", "B", "B"), B = c("A", "C"), C = "A"))
is_loopy(G)

G2 <- simplify(G)
is_loopy(G2)
}
\seealso{
Other multigraphs: 
\code{\link{is_multigraph}()},
\code{\link{is_simple}()},
\code{\link{remove_loops}()},
\code{\link{remove_multiple}()},
\code{\link{simplify}()}
}
\concept{multigraphs}
