% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleBoxplot.R
\name{multipleBoxplots}
\alias{multipleBoxplots}
\title{Multiple boxplots for many times}
\usage{
multipleBoxplots(data, x_var, y_var, add_points = TRUE)
}
\arguments{
\item{data}{a dataset from which the variable \code{x_var} and \code{y_var} should be taken.}

\item{x_var}{corresponding to the x coordinates for the plot, it must be a factor to obtain multiple boxplots.}

\item{y_var}{corresponding to the y coordinates for the plot.}

\item{add_points}{if you want to add points on boxplots. Default value is \code{TRUE}.}
}
\value{
a \code{ggplot2} object
}
\description{
Multiple boxplots for many times
}
\examples{
library(ggplot2)

#Generate data
x_ex <- factor(c(rep("J0", 10), rep("J7", 10), rep("J14", 10)), levels = c("J0", "J7", "J14"))
y_ex <- rnorm(30)

data_ex <- cbind.data.frame(x_ex, y_ex)

#Plotting
multipleBoxplots(data = data_ex, x_var = x_ex, y_var = y_ex)

multipleBoxplots(data = data_ex, x_var = x_ex, y_var = y_ex) + 
labs(x = "Time", y = "Value") + 
theme(legend.position = "none")
}
