% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.uncertainty_vector_cube}
\alias{plot.uncertainty_vector_cube}
\title{Plot uncertainty vector cubes}
\usage{
\method{plot}{uncertainty_vector_cube}(
  x,
  ...,
  tile = x[["tile"]][[1L]],
  roi = NULL,
  palette = "RdYlGn",
  rev = TRUE,
  scale = 1,
  legend_position = "inside"
)
}
\arguments{
\item{x}{Object of class "probs_vector_cube".}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{roi}{Region of interest (see note)}

\item{palette}{RColorBrewer or "cols4all" palette}

\item{rev}{Reverse order of colors in palette?}

\item{scale}{Scale to plot map (0.4 to 1.0)}

\item{legend_position}{Where to place the legend (default = "inside")}
}
\value{
A plot containing probabilities associated
                      to each class for each pixel.
}
\description{
plots a probability cube using stars
}
\note{
To see which color palettes are supported, please run cols4all::c4a_gui().
To define a \code{roi} use one of:
     \itemize{
       \item{A path to a shapefile with polygons;}
       \item{A \code{sfc} or \code{sf} object from \code{sf} package;}
       \item{A \code{SpatExtent} object from \code{terra} package;}
       \item{A named \code{vector} (\code{"lon_min"},
            \code{"lat_min"}, \code{"lon_max"}, \code{"lat_max"}) in WGS84;}
       \item{A named \code{vector} (\code{"xmin"}, \code{"xmax"},
             \code{"ymin"}, \code{"ymax"}) with XY coordinates.}
}
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # segment the image
    segments <- sits_segment(
        cube = cube,
        seg_fn = sits_snic(
            grid_seeding = "hexagonal",
            spacing = 7,
            compactness = 0.6,
            padding = 0
        ),
        output_dir = tempdir()
    )
    # classify a data cube
    probs_vector_cube <- sits_classify(
        data = segments,
        ml_model = rfor_model,
        output_dir = tempdir()
    )
    # measure uncertainty
    uncert_vector_cube <- sits_uncertainty(
        cube = probs_vector_cube,
        type = "margin",
        output_dir = tempdir()
    )
    # plot the resulting uncertainty cube
    plot(uncert_vector_cube)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
