% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clients.R
\name{con_iam}
\alias{con_iam}
\alias{paws_clients}
\alias{con_s3}
\alias{con_sm}
\alias{con_ec2}
\alias{con_rds}
\alias{con_redshift}
\alias{con_ce}
\title{Get a \code{paws} client for a service}
\usage{
con_iam()

con_s3()

con_sm()

con_ec2()

con_rds()

con_redshift()

con_ce()
}
\value{
\itemize{
\item \code{con_s3}: a list with methods for interfacing with S3;
\url{https://www.paws-r-sdk.com/docs/s3/}
\item \code{con_iam}: a list with methods for interfacing with IAM;
\url{https://www.paws-r-sdk.com/docs/iam/}
\item \code{con_sm}: a list with methods for interfacing with Secrets Manager;
\url{https://www.paws-r-sdk.com/docs/secretsmanager/}
\item \code{con_ec2}: a list with methods for interfacing with EC2;
\url{https://www.paws-r-sdk.com/docs/ec2/}
\item \code{con_rds}: a list with methods for interfacing with RDS;
\url{https://www.paws-r-sdk.com/docs/rds/}
\item \code{con_redshift}: a list with methods for interfacing with Redshift;
\url{https://www.paws-r-sdk.com/docs/redshift/}
\item \code{con_ce}: a list with methods for interfacing with Cost Explorer;
\url{https://www.paws-r-sdk.com/docs/costexplorer/}
}
}
\description{
Get a \code{paws} client for a service
}
\details{
Toggles the credentials used based on the environment
variable \code{AWS_PROFILE} for one of: minio, localstack, aws.

If \code{AWS_PROFILE} is "minio" then we set the following in the
credentials for the connection:
\itemize{
\item \code{access_key_id} uses env var \code{MINIO_USER}, with default "minioadmin"
\item \code{secret_access_key} uses env var \code{MINIO_PWD}, with default "minioadmin"
\item \code{endpoint} uses env var \code{MINIO_ENDPOINT}, with default
"http://127.0.0.1:9000"
}

If \code{AWS_PROFILE} is "localstack" then we set the following in the
credentials for the connection:
\itemize{
\item \code{access_key_id} uses env var \code{LOCALSTACK_KEY}, with a default
string which is essentially ignored. you do not need to set the
\code{LOCALSTACK_KEY} env var. However, if you want to set an account
ID for your Localstack you can set the env var and it will be used.
see \url{https://docs.localstack.cloud/references/credentials/}
\item \code{secret_access_key} uses env var \code{LOCALSTACK_SECRET}, with a default
string which is ignored; and any value you set for \code{LOCALSTACK_SECRET}
will be ignored by Localstack as well. see
\url{https://docs.localstack.cloud/references/credentials/}
\item \code{endpoint} uses env var \code{LOCALSTACK_ENDPOINT}. You can set this to
the URL for where your Localstack is running at. Default is
\verb{http://localhost.localstack.cloud:4566}
}

If \code{AWS_PROFILE} is not set, set to "aws", or anything else (other
than "localstack") then we don't set any credentials internally, but
\code{paws} will gather any credentials you've set via env vars, config
files, etc.-
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
z <- con_iam()
z

withr::with_envvar(
  c("AWS_PROFILE" = "localstack"),
  con_iam()
)
withr::with_envvar(
  c("AWS_PROFILE" = "minio"),
  con_s3()
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=con_s3fs]{con_s3fs()}}
}
