% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{six_bucket_upload}
\alias{six_bucket_upload}
\title{Magically upload a mix of files and directories into a bucket}
\usage{
six_bucket_upload(path, remote, force = FALSE, ...)
}
\arguments{
\item{path}{(character) one or more file paths to add to
the \code{bucket}. required. can include directories or files}

\item{remote}{(character/scalar) a character string to use to upload
files in \code{path}. the first component of the path will be used as the
bucket name. any subsequent path components will be used as a
key prefix for all objects created in the bucket}

\item{force}{(logical) force bucket creation without going through
the prompt. default: \code{FALSE}. Should only be set to \code{TRUE} when
required for non-interactive use.}

\item{...}{named params passed on to
\href{https://www.paws-r-sdk.com/docs/s3_put_object/}{put_object}}
}
\value{
(character) a vector of remote s3 paths where your
files are located
}
\description{
Magically upload a mix of files and directories into a bucket
}
\section{What is magical}{

\itemize{
\item Exits early if folder or files do not exist
\item Creates the bucket if it does not exist
\item Adds files to the bucket at the top level with key as the file name
\item Adds directories to the bucket, reconstructing the exact directory
structure in the S3 bucket
}
}

\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# single file, single remote path
bucket1 <- random_bucket()
demo_rds_file <- file.path(system.file(), "Meta/demo.rds")
six_bucket_upload(path = demo_rds_file, remote = bucket1, force = TRUE)

## a file and a directory - with a single remote path
bucket2 <- random_bucket()
library(fs)
tdir <- path(path_temp(), "mytmp")
dir_create(tdir)
invisible(purrr::map(letters, \(l) file_create(path(tdir, l))))
dir_tree(tdir)
six_bucket_upload(path = c(demo_rds_file, tdir), remote = bucket2,
force = TRUE)

## a directory with nested dirs - with a single remote path
bucket3 <- random_bucket()
library(fs)
tdir <- path(path_temp(), "apples")
dir_create(tdir)
dir_create(path(tdir, "mcintosh"))
dir_create(path(tdir, "pink-lady"))
cat("Some text in a readme", file = path(tdir, "README.md"))
write.csv(Orange, file = path(tdir, "mcintosh", "orange.csv"))
write.csv(iris, file = path(tdir, "pink-lady", "iris.csv"))
dir_tree(tdir)
six_bucket_upload(path = tdir, remote = path(bucket3, "fruit/basket"),
force = TRUE)

# cleanup
six_bucket_delete(bucket1, force = TRUE)
six_bucket_delete(bucket2, force = TRUE)
six_bucket_delete(bucket3, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other buckets: 
\code{\link{aws_bucket_create}()},
\code{\link{aws_bucket_delete}()},
\code{\link{aws_bucket_download}()},
\code{\link{aws_bucket_exists}()},
\code{\link{aws_bucket_list_objects}()},
\code{\link{aws_bucket_tree}()},
\code{\link{aws_bucket_upload}()},
\code{\link{aws_buckets}()},
\code{\link{six_bucket_delete}()}

Other magicians: 
\code{\link{six_admin_setup}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_file_upload}()},
\code{\link{six_user_create}()},
\code{\link{six_user_delete}()}
}
\concept{buckets}
\concept{magicians}
