% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_urls.R
\name{check_urls}
\alias{check_urls}
\title{Check urls in dynamic report files}
\usage{
check_urls(path = ".")
}
\arguments{
\item{path}{Path to the directory containing the files to be checked. Default is current directory.}
}
\value{
A url_checker_db object with an added class with a custom print method.
}
\description{
\code{check_urls} Check urls in dynamic report files (.md, .Rmd & .qmd)
}
\details{
The function can be used to check if url addresses in dynamic reports are broken. Taken from Nan Xiao's blogpost (\url{https://nanx.me/blog/post/rmarkdown-quarto-link-checker/}).
}
\examples{
{
data(compendiums)

# make compendiums
make_compendium(name = "my_compendium", path = tempdir(),
format = "basic", force = TRUE)

# check urls in scripts
check_urls(path = file.path(tempdir(), "./scripts"))
}

}
\references{
{
Araya-Salas, M., Arriaga, A. (2023), sketchy: research compendiums for data analysis in R. R package version 1.0.3.
Xiao, N. (2023). A General-Purpose Link Checker for R Markdown and Quarto Projects. Blog post. https://nanx.me/blog/post/rmarkdown-quarto-link-checker/
}
}
\seealso{
\code{\link{add_to_gitignore}}, \code{\link{make_compendium}}
}
\author{
Nan Xiao (\email{me@nanx.me})
}
