% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clda.R
\name{clda}
\alias{clda}
\title{Curvilinear Distance Analysis (CLDA)}
\usage{
clda(
  delta,
  Epochs = 20,
  alpha0 = 0.5,
  lambda0,
  ndim = 2,
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  acc = 1e-06,
  itmax = 10000,
  verbose = 0,
  method = "euclidean",
  principal = FALSE,
  epsilon,
  k,
  path = "shortest",
  fragmentedOK = FALSE
)
}
\arguments{
\item{delta}{dist object or a symmetric, numeric data.frame or matrix of distances. Will be turne dinto geodesci distances.}

\item{Epochs}{Scalar; gives the number of passes through the data.}

\item{alpha0}{(scalar) initial step size, 0.5 by default}

\item{lambda0}{the boundary/neighbourhood parameter(s) (called lambda_y in the original paper). It is supposed to be a numeric scalar. It defaults to the 90\% quantile of delta.}

\item{ndim}{dimension of the configuration; defaults to 2}

\item{weightmat}{not used}

\item{init}{starting configuration, not used}

\item{acc}{numeric accuracy of the iteration; not used}

\item{itmax}{maximum number of iterations. Not used.}

\item{verbose}{should iteration output be printed; not used}

\item{method}{Distance calculation; currently not used.}

\item{principal}{If 'TRUE', principal axis transformation is applied to the final configuration}

\item{epsilon}{Shortest dissimilarity retained.}

\item{k}{Number of shortest dissimilarities retained for a point. If both 'epsilon' and 'k' are given, 'epsilon' will be used.}

\item{path}{Method used in 'stepacross' to estimate the shortest path, with alternatives '"shortest"' and '"extended"'.}

\item{fragmentedOK}{What to do if dissimilarity matrix is fragmented. If 'TRUE', analyse the largest connected group, otherwise stop with error.}
}
\value{
a 'smacofP' object. It is a list with the components
\itemize{
\item delta: Observed, untransformed dissimilarities
\item tdelta: Observed explicitly transformed dissimilarities, normalized
\item dhat: Explicitly transformed dissimilarities (dhats), optimally scaled and normalized 
\item confdist: Configuration dissimilarities
\item conf: Matrix of fitted configuration
\item stress: Default stress (stress-1; sqrt of explicitly normalized stress)
\item spp: Stress per point 
\item ndim: Number of dimensions
\item model: Name of model
\item niter: Number of iterations (training length)
\item nobj: Number of objects
\item type: Type of MDS model. Only ratio here.
\item weightmat: weighting matrix as supplied
\item stress.m: Default stress (stress-1^2)
\item tweightmat: transformed weighting matrix; it is weightmat here.
}
}
\description{
A function to run curvilinear distance analysis via \code{\link[ProjectionBasedClustering]{CCA}} and returning a 'smacofP' object. Note this functionality is rather rudimentary.
}
\details{
This implements CLDA as CLCA with geodesic distances. The geodesic distances are calculated via 'vegan::isomapdist', see \code{\link[vegan]{isomapdist}} for a documentation of what these distances do. 'clda' is just a wrapper for 'clca' applied to the geodesic distances obtained via isomapdist.
}
\examples{
dis<-smacof::morse
res<-clda(dis,lambda0=0.4,k=4)
res
summary(res)
plot(res)

}
