% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smmfit.R
\name{plot.smmfit}
\alias{plot.smmfit}
\title{Plot function for an object of class smmfit}
\usage{
\method{plot}{smmfit}(x, i, j, klim = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{smmfit} (inheriting from the S3 classes
\code{smm}, \link{smmnonparametric} or \link{smmparametric}).}

\item{i}{An element of the state space vector \code{x$states} giving the current
state in the following cases: \code{type.sojourn = "fij"} or \code{type.sojourn = "fi"},
otherwise, \code{i} is ignored.}

\item{j}{An element of the state space vector \code{x$states} giving the next
state in the following cases: \code{type.sojourn = "fij"} or \code{type.sojourn = "fj"},
otherwise, \code{j} is ignored.}

\item{klim}{An integer giving the limit value for which the density will be
plotted. If \code{klim} is \code{NULL}, then quantile or order 0.95 is used.}

\item{...}{Arguments passed to plot.}
}
\value{
None.
}
\description{
Displays the densities for the conditional sojourn time
distributions depending on the current state \code{i} and on the next state
\code{j}.
}
\examples{
states <- c("a", "c", "g", "t")
s <- length(states)

# Creation of the initial distribution
vect.init <- c(1 / 4, 1 / 4, 1 / 4, 1 / 4)

# Creation of the transition matrix
pij <- matrix(c(0, 0.2, 0.3, 0.4, 0.2, 0, 0.5, 0.2, 0.5, 
                0.3, 0, 0.4, 0.3, 0.5, 0.2, 0), ncol = s)

# Creation of the distribution matrix
distr.vec <- c("pois", "geom", "geom", "geom")
parameters <- matrix(c(2, 0.6, 0.8, 0.8, NA, NA, NA, NA), 
                     ncol = 2, byrow = FALSE)

# Specify the semi-Markov model
smm <- smmparametric(states = states, init = vect.init, ptrans = pij, 
                     type.sojourn = "fi", distr = distr.vec, param = parameters)

seqs <- simulate(object = smm, nsim = rep(5000, 100), seed = 10)

est <- fitsmm(sequences = seqs, states = states, type.sojourn = "fi", distr = distr.vec)

class(est)

plot(x = est, i = "a", col = "blue", pch = "+")

}
\references{
V. S. Barbu, N. Limnios. (2008). Semi-Markov Chains and Hidden Semi-Markov
Models Toward Applications - Their Use in Reliability and DNA Analysis.
New York: Lecture Notes in Statistics, vol. 191, Springer.
}
