% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{logTaylor}
\alias{logTaylor}
\title{Modified logarithm with derivatives}
\usage{
logTaylor(x, lower = NULL, upper = NULL, der = 0, order = 4)
}
\arguments{
\item{x}{Numeric vector for which approximated logarithm is to be computed.}

\item{lower}{Lower threshold below which approximation starts; can be a scalar of a vector of the same length as \code{x}.}

\item{upper}{Upper threshold above which approximation starts; can be a scalar of a vector of the same length as \code{x}.}

\item{der}{Non-negative integer: 0 yields the function, 1 and higher yields derivatives}

\item{order}{Positive integer: Taylor approximation order. If \code{NA}, returns \code{log(x)} or its derivative.}
}
\value{
A numeric matrix with \code{(order+1)} columns containing the values of the modified log and its derivatives.
}
\description{
Modified logarithm with derivatives
}
\details{
Provides a family of alternatives to -log() and derivative thereof in order to attain self-concordance and
computes the modified negative logarithm and its first derivatives.
For lower <= x <= upper, returns just the logarithm. For x < lower and x > upper, returns the Taylor approximation of the given \code{order}.
4th order is the lowest that gives self concordance.
}
\examples{
x <- seq(0.01^0.25, 2^0.25, length.out = 51)^4 - 0.11 # Denser where |f'| is higher
plot(x,  log(x)); abline(v = 0, lty = 2) # Observe the warning
lines(x, logTaylor(x, lower = 0.2), col = 2)
lines(x, logTaylor(x, lower = 0.5), col = 3)
lines(x, logTaylor(x, lower = 1, upper = 1.2, order = 6), col = 4)

# Substitute log with its Taylor approx. around 1
x <- seq(0.1, 2, 0.05)
ae <- abs(sapply(2:6, function(o) log(x) - logTaylor(x, lower=1, upper=1, order=o)))
matplot(x[x!=1], ae[x!=1,], type = "l", log = "y", lwd = 2,
  main = "Abs. trunc. err. of Taylor expansion at 1", ylab = "")

# Vanilla logarithm
identical(logTaylor(2, order = NA), log(2))
}
