% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill-holes.R
\name{fill_holes}
\alias{fill_holes}
\title{Fill small holes in polygons}
\usage{
fill_holes(x, threshold)
}
\arguments{
\item{x}{spatial features; lines or polygons from either the \code{sf}, \code{sp}, or
\code{terra} packages.}

\item{threshold}{an area threshold, below which holes will be removed.
Provided either as a \code{units} object (see \code{\link[units:units]{units::set_units()}}), or a
numeric threshold in the units of the coordinate reference system. If \code{x}
is in unprojected coordinates, a numeric threshold is assumed to be in
square meters. A threshold of 0 will return the input polygons unchanged.}
}
\value{
A spatial feature, with holes filled, in the same format as the input
data.
}
\description{
Fill polygon holes that fall below a given area threshold.
}
\examples{
# fill holes smaller than 1000km2
p <- jagged_polygons$geometry[5]
area_thresh <- units::set_units(1000, km^2)
p_dropped <- fill_holes(p, threshold = area_thresh)
# plot
par(mar = c(0, 0, 1, 0), mfrow = c(1, 2))
plot(p, col = "black", main = "Original")
plot(p_dropped, col = "black", main = "After fill_holes()")
}
