% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_smos.R
\name{list_smos}
\alias{list_smos}
\title{List BEC-SMOS data files stored on a local computer}
\usage{
list_smos(
  freq = NULL,
  orbit = NULL,
  dates = NULL,
  dir = NULL,
  recursive = FALSE
)
}
\arguments{
\item{freq}{an integer specifying temporal frequency of the data. Possible
values are: 1 - for daily data, or 3 - for 3-day moving averages, and NULL -
for cases when data frequency is irrelevant. Default value is \code{NULL}.}

\item{orbit}{a character (or character string) specifying SMOS orbit
corresponding to the data. Possible values are: ‘a’, ‘asc’, and ‘ascending’ -
for an ascending pass, or ‘d’, ‘des’, or ‘descending’ - for a descending
pass, and NULL - for cases when orbit is irrelevant. Default value is
\code{NULL}.}

\item{dates}{an object of class \code{Date} or a character string formatted
as ‘yyyy-mm-dd’ (e.g. ‘2010-06-01’) which specifies the date(s) to search
through. To look for a specific date, it can be a Date object or a character
vector of length 1. To iterate over various dates or a time interval, a
multiple-element object of class Date or a vector should be passed (e.g. as
produced by \code{seq.Date}).}

\item{dir}{a character string specifying a path to a local directory in which
to search the data for. Default value is \code{NULL} meaning that the dataset
is looked up in a temporary directory of the current R session.}

\item{recursive}{a logical vector indicating whether the listing should
recurse into directories. Default is \code{FALSE}.}
}
\value{
a character vector containing full links to the data files on the
local computer.
}
\description{
This function returns a list of the BEC-SMOS data files previously stored on
a local computer.
}
\details{
This function iterates over all files in a temporary directory of the
current R session (default option) or another local folder as indicated by
\code{dir} argument and returns a list of the BEC-SMOS data files with the
\code{frequency}, \code{orbit}, and \code{dates} specified by the user. If
no arguments are provided, all BEC-SMOS soil moisture data files found in
the selected folder will be listed. A recursive option is also available.
}
\examples{
\dontrun{
# to list BEC-SMOS data files with the specified frequency and SMOS orbit
# stored in a temporary directory of the current R session
smos_files <- list_smos(freq = 3, orbit = "des")
}

}
\references{
Pablos M, Gonzalez-Haro C, Portal G, Piles M, Vall-llossera M,
Portabella M (2022). SMOS L4 Surface Soil Moisture downscaled maps at 1 km
EASE-2 (reprocessed mode) (V.6.0) [Dataset].
}
