% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_slope.R
\name{sm_slope}
\alias{sm_slope}
\title{Slope Chart}
\usage{
sm_slope(
  ...,
  labels,
  group,
  line.params = list(color = "gray53", linewidth = 0.4, alpha = 0.4),
  point.params = list(size = 2.5, shape = 21, color = "white"),
  avgLine.params = list(linewidth = 1),
  avgPoint.params = list(size = 4),
  err.params = list(linewidth = 1),
  xTick.params = list(position = "top", expand = c(0.17, 0.1), drop = FALSE),
  errorbar_type = "sd",
  many_groups = FALSE,
  show_err = FALSE,
  show_mean = FALSE,
  legends = FALSE,
  forget = FALSE
)
}
\arguments{
\item{...}{Additional aesthetic parameters applied across points and lines, such as \code{color}, \code{alpha}, and \code{fill}. Optional.}

\item{labels}{A vector specifying the labels for the x-axis ticks. This is a required argument.
For example: \code{c('Day 1', 'Day 2')}.}

\item{group}{The name of the variable used to group individual data points. This is a required argument.}

\item{line.params}{A list of parameters for individual lines. Common parameters include:
\itemize{
  \item \code{color}: Color of the lines.
  \item \code{alpha}: Transparency of the lines.
  \item \code{linewidth}: Width of the lines.
}
Default: \code{list(color = 'gray53', linewidth = 0.4, alpha = 0.4)}.}

\item{point.params}{A list of parameters for individual points. Common parameters include:
\itemize{
  \item \code{size}: Size of the points.
  \item \code{shape}: Shape of the points.
  \item \code{color}: Color of the points.
}
Default: \code{list(size = 2.5, shape = 21, color = 'white')}.}

\item{avgLine.params}{A list of parameters for the average line. Common parameters include:
\itemize{
  \item \code{color}: Color of the average line.
  \item \code{linewidth}: Width of the average line.
}
Default: \code{list(linewidth = 1)}.}

\item{avgPoint.params}{A list of parameters for the average points. Common parameters include:
\itemize{
  \item \code{size}: Size of the average points.
  \item \code{fill}: Fill color of the average points.
}
Default: \code{list(size = 4)}.}

\item{err.params}{A list of parameters for error bars. Common parameters include:
\itemize{
  \item \code{color}: Color of the error bars.
  \item \code{linewidth}: Width of the error bars.
}
Default: \code{list(linewidth = 1)}.}

\item{xTick.params}{A list of parameters for customizing the x-axis ticks. Common options include:
\itemize{
  \item \code{position}: Location of the ticks (default: \code{'top'}).
  \item \code{expand}: Space around the ticks (default: \code{c(0.17, 0.1)}).
  \item \code{drop}: Whether to drop unused factor levels (default: \code{FALSE}).
}}

\item{errorbar_type}{A string specifying the type of error bars to display:
\itemize{
  \item \code{'se'}: Standard error.
  \item \code{'sd'}: Standard deviation (default).
  \item \code{'ci'}: 95% confidence interval.
}}

\item{many_groups}{Logical. Determines whether the average line is plotted for each group:
\itemize{
  \item \code{TRUE}: An average line is plotted for each group.
  \item \code{FALSE}: A single average line is plotted across all data.
}
Default: \code{FALSE}.}

\item{show_err}{Logical. Determines whether to display error bars:
\itemize{
  \item \code{TRUE}: Display error bars.
  \item \code{FALSE}: Hide error bars (default).
}}

\item{show_mean}{Logical. Determines whether to display the average line and points:
\itemize{
  \item \code{TRUE}: Display the average line and points.
  \item \code{FALSE}: Hide the average line and points (default).
}}

\item{legends}{Logical. Determines whether to display legends:
\itemize{
  \item \code{TRUE}: Display legends.
  \item \code{FALSE}: Hide legends (default).
}}

\item{forget}{Logical. Determines whether to apply the default aesthetic parameters:
\itemize{
  \item \code{TRUE}: Ignore default aesthetic parameters (\code{line.params}, \code{point.params}, etc.)
        and apply only user-supplied customizations.
  \item \code{FALSE}: Merge user-supplied customizations with the defaults (default).
}}
}
\value{
A list of ggplot2 layers for creating a slope chart.
}
\description{
Generates a slope chart, which is particularly useful for comparing effects between two time points.
The function supports grouped data and provides various customization options for lines, points, error bars,
and x-axis ticks. Users can specify the type of error bars and control whether to display mean and error bars.

The mapping in `ggplot()` requires grouping each observation to ensure correct pairing of points.
}
\examples{
library(ggplot2)
library(smplot2)

set.seed(1) # generate random data
day1 = rnorm(16,2,1)
day2 = rnorm(16,5,1)
Subject <- rep(paste0('S',seq(1:16)), 2)
Data <- data.frame(Value = matrix(c(day1,day2),ncol=1))
Day <- rep(c('Day 1', 'Day 2'), each = length(day1))
df <- cbind(Subject, Data, Day)

ggplot(data=df, aes(x = Day, y = Value, fill = Day)) +
 sm_slope(labels = c('Day 1', 'Day 2'), group = Subject) +
 scale_fill_manual(values=  sm_color('blue','orange'))
ggplot(data = df, aes(x = Day, y = Value, fill = Day)) +
 sm_slope(labels = c('Day 1','Day 2'),group = Subject,
          point.params = list(alpha = 0.3, size = 2.5, color = 'white',
                              shape = 21, fill = sm_color('skyblue')),
          line.params = list(color = sm_color('skyblue'),
                             alpha = 0.3),
          avgPoint.params = list(color='transparent', shape = 21,
                                 size = 4, fill = sm_color('blue')),
          avgLine.params = list(color = sm_color('blue'), linewidth = 1),
          show_mean = TRUE)


}
