% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominance_value.R
\name{dvalue}
\alias{dvalue}
\title{Dominance value}
\usage{
dvalue(dmatrix)
}
\arguments{
\item{dmatrix}{Sij dyadic relationship matrix}
}
\value{
dominance value, social rank and social hierarchy
}
\description{
Function to obtain the dominance value, social rank and hierarchy
from Sij dyadic relationship matrix.
}
\details{
The social categories (rank and hierarchy) are define according to dominance value and
is obtained by the following expression: SH =(|Distance between highest(+ X) and lowest(- Y) dominance value| + 1)
/(2 or 3), where "SH" is the rank or hierarchy. The rank (high and lower) and social
category (dominant, intermediate and subordinate) are determined assigned according to
dominance value. The choice for divide the group by rank or social category depends of
the study objective. Both rank and social category are estimated by the distance between
the highest (+ X) and the lowest (- Y) dominance value, plus 1 (corresponds to the dominance
value zero), which determines the number of points in the range.
}
\examples{

x <- matrix(c(0,-1,1,0,-1,1,0,0,1,0,-1,-1,0,1,0,0,
             -1,1,0,-1,1,-1,0,0,0,1,1,0,-1,0,0,0,
             1,0,-1,1,0,0,1,0,-1,-1,1,0,0,0,0,1,
             0,0,0,0,-1,0,0,0,0,0,0,0,0,-1,0,0),
             nrow=8,byrow=TRUE,)
             
colnames(x) <- c(1,2,3,4,5,6,8,9)

rownames(x) <- c(1,2,3,4,5,6,8,9)

dominance <- dvalue(x)

print(dominance)

}
\references{
Coimbra, P. A. D., Machado Filho, L. C. P., & Hötzel, M. J. (2012). Effects of social dominance,
water trough location and shade availability on drinking behaviour of cows on pasture. Applied
Animal Behaviour Science, 139(3-4), 175-182.
}
\author{
Julia P. S. Valente, Matheus Deniz, Karolini T. de Sousa.
}
