% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_create.r
\name{db_create}
\alias{db_create}
\title{Create a database.}
\usage{
db_create(cushion, dbname, delifexists = FALSE, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{Database name}

\item{delifexists}{If \code{TRUE}, delete any database of the same name before
creating it. This is useful for testing. Default: \code{FALSE}}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Create a database.
}
\examples{
\dontrun{
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

if ("leothetiger" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="leothetiger"))
}
db_create(x, dbname='leothetiger')

## see if its there now
db_list(x)
}
}
