% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softImpute-package.R
\docType{package}
\name{softImpute-package}
\alias{softImpute-package}
\title{Softimpute for matrix completion}
\description{
SoftImpute solves the following problem for a matrix \eqn{X} with missing
entries: \eqn{\min||X-M||_o^2 +\lambda||M||_*.} Here \eqn{||\cdot||_o} is
the Frobenius norm, restricted to the entries corresponding to the
non-missing entries of \eqn{X}, and \eqn{||M||_*} is the nuclear norm of
\eqn{M} (sum of singular values).  For full details of the "svd" algorithm
are described in the reference below.  The "als" algorithm will be described
in a forthcoming article. Both methods employ special sparse-matrix tricks
for large matrices with many missing values. This package creates a new
sparse-matrix class \code{"SparseplusLowRank"} for matrices of the form
\deqn{x+ab',} where \eqn{x} is sparse and \eqn{a} and \eqn{b} are tall
skinny matrices, hence \eqn{ab'} is low rank. Methods for efficient left and
right matrix multiplication are provided for this class. For large matrices,
the function \code{Incomplete()} can be used to build the appropriate sparse
input matrix from market-format data.
}
\references{
Rahul Mazumder, Trevor Hastie and Rob Tibshirani (2010)
\emph{Spectral Regularization Algorithms for Learning Large Incomplete
Matrices}, \url{https://hastie.su.domains/Papers/mazumder10a.pdf}
\emph{ Journal of Machine Learning Research 11 (2010) 2287-2322}\cr
Trevor Hastie, Rahul Mazumder, Jason Lee, Reza Zadeh (2015) \emph{Matrix Completion and Low-rank  SVD via Fast Alternating Least Squares},
\url{https://arxiv.org/abs/1410.2596}\cr \emph{Journal of Machine Learning Research, 16, 3367-3402}
}
\author{
Trevor Hastie and Rahul Mazumder

Maintainer: Trevor Hastie\href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{internal}
