% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SDA_NASIS_keys.R
\name{get_SDA_NASIS_key}
\alias{get_SDA_NASIS_key}
\title{Get NASIS Record IDs from Soil Data Access}
\usage{
get_SDA_NASIS_key(
  x,
  by = "mukey",
  include_chorizon = FALSE,
  query_string = FALSE,
  dsn = NULL
)
}
\arguments{
\item{x}{A character vector of keys to match (\code{mukey}, \code{cokey}, or \code{chkey}).}

\item{by}{A character string indicating the type of key provided in \code{x}. Must
be one of \code{"mukey"}, \code{"cokey"}, or \code{"chkey"}.}

\item{include_chorizon}{Logical. If \code{TRUE}, join results to \code{chorizon} table
to include \code{"nasischiid"}. Default: \code{FALSE} but always \code{TRUE} for
\code{by="chkey"}.}

\item{query_string}{Logical. If \code{TRUE}, return the SQL query string instead
of executing it. Default: \code{FALSE}.}

\item{dsn}{Optional. Path to a local database or connection object. If \code{NULL}
(default), the SDA web service is used.}
}
\value{
A \code{data.frame} containing \code{mukey}, \code{cokey}, \code{chkey}, \code{nasiscoiid},
and \code{nasischiid}, or a character string if \code{query_string = TRUE}.
}
\description{
Query the Soil Data Access (SDA) API for NASIS record identifiers
(\code{nasiscoiid}, \code{nasischiid}) associated with map units, components, or
horizons. These identifiers are available in SDA beginning with NASIS version
7.4.3 and are useful for linking SDA data to NASIS backend records.
}
\details{
This function is intended for use with SDA (\code{dsn = NULL}). When used with
local SSURGO snapshots or other data sources, these columns may not be
present.
}
\note{
These NASIS record ID columns are only available via SDA after the
October 1, 2025 refresh. They are not included in SSURGO snapshot data
from Web Soil Survey unless manually added by the user.
}
\examples{
\dontrun{
# Get NASIS component IDs for a set of map unit keys
get_SDA_NASIS_key(c("469093"), by = "mukey")

# Get NASIS component and chorizon IDs for a set of map unit keys
get_SDA_NASIS_key(c("469093"), by = "mukey", include_chorizon = TRUE)
}
}
