% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_inputs.R
\name{calculate_inputs}
\alias{calculate_inputs}
\title{A function to calculate the inputs and outputs at equilibrium and print them for the user.}
\usage{
calculate_inputs(
  usin,
  DIETLIMTS = NA,
  diet_correct = TRUE,
  Conly = FALSE,
  verbose = TRUE,
  toround = TRUE
)
}
\arguments{
\item{usin}{The community you want to simulate.}

\item{DIETLIMTS}{The diet limits matrix for the stoichiometry correction (proportion of diet)?}

\item{diet_correct}{Boolean: Does the organism correct it's diet?}

\item{Conly}{Boolean: Is the model meant for carbon only?}

\item{verbose}{Boolean: Do you want to print the summary in the Console?}

\item{toround}{Boolean: Should the answer be rounded?}
}
\value{
A list of inputs and mineralization rates.
}
\description{
A function to calculate the inputs and outputs at equilibrium and print them for the user.
}
\examples{
# Calculate the inputs and outputs of a community. Prints a summary by default and saves a list.
calculate_inputs(intro_comm)
}
