% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Altitude.R
\name{Altitude}
\alias{Altitude}
\title{Solar Altitude Angle}
\usage{
Altitude(DOY, Lat, Lon, SLon, DS)
}
\arguments{
\item{DOY}{Day of year}

\item{Lat}{Latitude in degrees}

\item{Lon}{Longitude in degrees}

\item{SLon}{Standard longitude (based on time zone) in degrees}

\item{DS}{Daylight saving in minutes}
}
\description{
This function solar altitude angle (in degrees) for a given day of year and location.
}
\examples{

#Calculating solar altitude angle for two consecutive days

DOY <- seq(0, 2, .05)

alpha <- Altitude(DOY, Lat = 45, Lon=0, SLon=0, DS=60)
#Note: only the difference between Lon and SLon matters not each value

plot(DOY, alpha)
}
\keyword{Altitude}
