% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOMnn.R
\name{initialize,SOMnn-method}
\alias{initialize,SOMnn-method}
\alias{initialize,ANY,ANY-method}
\title{Constructor of SOMnn Class}
\usage{
\S4method{initialize}{SOMnn}(
  .Object,
  name,
  codes,
  qerror,
  class.idx,
  classes,
  class.counts,
  class.freqs,
  confusion,
  measures,
  accuracy,
  xdim,
  ydim,
  len.total,
  toroidal,
  norm,
  norm.center,
  norm.scale,
  dist.fun,
  max.dist,
  strict
)
}
\arguments{
\item{.Object}{SOMnn object}

\item{name}{optional name of the model.}

\item{codes}{\code{data.frame} with codebook vectors of the som.}

\item{qerror}{sum of the mapping errors of the training data.}

\item{class.idx}{\code{numeric} index of column with categories.}

\item{classes}{\code{character} vector with names of categories.}

\item{class.counts}{\code{data.frame} with class hits for each neuron.}

\item{class.freqs}{\code{data.frame} with class frequencies for each neuron
(freqs sum up to 1).}

\item{confusion}{\code{data.frame} with confusion matrix for training data.}

\item{measures}{\code{data.frame} with classes as rows and the
columns sensitivity, specificity and accuracy for each class.}

\item{accuracy}{Overall accuracy.}

\item{xdim}{number of neurons in x-direction of the som.}

\item{ydim}{number of neurons in y-direction of the som.}

\item{len.total}{total number of training steps, performed to create the model.}

\item{toroidal}{\code{logical}; if TRUE, the map is toroidal (i.e. borderless).}

\item{norm}{\code{logical}; if TRUE, data is normalised before training and mapping.
Parameters for normalisation of training data is stored in the model and
applied before mapping of test data.}

\item{norm.center}{vector of centers for each column of training
data.}

\item{norm.scale}{vector of scale factors for each column of training
data.}

\item{dist.fun}{\code{function}; kernel for the kNN classifier.}

\item{max.dist}{maximum distance \eqn{\sigma} for the kNN classifier.}

\item{strict}{Minimum vote for the winner (if the winner's vote is smaller than strict,
"unknown" is reported as class label (\code{default = 0.8}).}
}
\description{
The constructor creates a new object of type SOMnn.
}
\details{
The constructor needs not to be called directly, because the normal
way to create a SOMnn object is to use \code{\link{som.nn.train}}.
}
\examples{
\dontrun{
new.som <- new("SOMnn", name = name,
              codes = codes,
              qerror = qerror,
              classes = classes, 
              class.idx = class.idx,
              class.counts = class.counts, 
              class.freqs = class.freqs,
              confusion = confusion, 
              measures = measures,
              accuracy = accuracy,
              xdim = xdim, 
              ydim = ydim, 
              len.total = len.total, 
              toroidal = toroidal,
              norm = norm, 
              norm.center = norm.center, 
              norm.scale = norm.scale,
              dist.fun = dist.fun, 
              max.dist = max.dist.
              strict = strict)
}

}
