% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generatePlot.R
\name{generatePlot}
\alias{generatePlot}
\title{Generate SOM Visualization Plots}
\usage{
generatePlot(model, plot_type, data = NULL)
}
\arguments{
\item{model}{A trained SOM model object.}

\item{plot_type}{An integer specifying the type of plot to generate. Options are:
\describe{
  \item{1}{Training progress plot (changes during training).}
  \item{2}{Node count plot (number of samples mapped to each node) for assessing map quality.}
  \item{3}{U-matrix plot (visualizing similarities between neighboring nodes).}
  \item{4}{Weight vector plot (patterns in the distributions of variables).}
  \item{5}{Kohonen heatmaps for all variables in the dataset (distribution of single variables across the map).}
}}

\item{data}{A preprocessed data matrix containing the input data. Required only for `plot_type = 5`.}
}
\value{
A plot or a series of plots is generated and displayed based on the specified type.
}
\description{
Creates various types of plots to visualize and evaluate the trained SOM model.
}
\examples{
# Create a toy matrix with 9 columns and 100 rows
data <- matrix(rnorm(900), ncol = 9, nrow = 100)  # 900 random numbers, 100 rows, 9 columns

# Assign column names to the data matrix
colnames(data) <- paste("Var", 1:ncol(data), sep = "_")

# Run the finalSOM function with the mock data
model <- finalSOM(data, dimension = 6, iterations = 700)

# Generate plots using the mock model
generatePlot(model, plot_type = 2)
generatePlot(model, plot_type = 5, data)
}
