% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sonar.R
\name{SpeedOfSoundPureWaterBelogolskiiSekoyanEtal}
\alias{SpeedOfSoundPureWaterBelogolskiiSekoyanEtal}
\title{speed of sound (m/s) from Belogolskii, Sekoyan et al}
\source{
National Physical Laboratory, 2015
Underwater Acoustics Technical Guides - Speed of Sound in Pure Water
\url{http://resource.npl.co.uk/acoustics/techguides/soundpurewater/content.html#LUBBERS}
}
\usage{
SpeedOfSoundPureWaterBelogolskiiSekoyanEtal(temperatureC, pressureMegaPascals)
}
\arguments{
\item{temperatureC,}{temperatureC in Celsius}

\item{pressureMegaPascals,}{pressure in mega Pascals}
}
\value{
the speed of sound (m/s)
}
\description{
Returns the speed of sound (m/s)
Range of validity: 0-40C, 0.1 - 60 MPa
}
\examples{
SpeedOfSoundPureWaterBelogolskiiSekoyanEtal(25, 1)
}
\author{
Jose Gama
}
\references{
Belogolskii, Sekoyan et al, 1999
Pressure dependence of the sound velocity in distilled water, Measurement Techniques, Vol 42, No 4, pp 406-413.
}

