\name{summary.spARCH}
\alias{summary.spARCH}
\alias{print.summary.spARCH}
\alias{print.spARCH}
\title{
Summary for spARCH object
}
\description{
The function returns a summary of the model fit of a spatial ARCH model (\code{qml.spARCH} or \code{qml.SARspARCH}).
}
\usage{
\method{summary}{spARCH}(object, ...)
\method{print}{summary.spARCH}(x, digits = max(5, .Options$digits - 3),
	signif.stars = TRUE, ...)
\method{print}{spARCH}(x, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{\linkS4class{spARCH} object generated by \code{\link{qml.spARCH}} or \code{\link{qml.SARspARCH}}.}
  \item{digits}{The number of significant digits to be printed.}
  \item{signif.stars}{Logical variable. If TRUE, significance stars are printed for each coefficient.}
  \item{x}{\linkS4class{spARCH} object of \code{\link{qml.spARCH}}.}
  \item{\dots}{further arguments passed to or from other methods}
}
\details{
The function \code{summary.spARCH} returns an \linkS4class{spARCH} object with all results (coefficients, residuals, diagnostic checks etc.). If the returned object is printed, a detailed summary of the model fit is returned.
}
\value{
The function returns the input \linkS4class{spARCH} object, plus
\item{Coef}{a matrix with columns for the estimated coefficients, their standard error, t-statistics and corresponding (two-sided, asymptotic) p-values.}
\item{AIC}{Akaike information criterion}
\item{BIC}{Bayesian Schwarz information criterion}
\item{moran_res}{Test on spatial spatial autocorrelation of the residuals (based on Morans I, \code{\link[spdep]{moran.test}}).}
\item{moran_sq_res}{Test on spatial spatial autocorrelation of the squared residuals (based on Morans I, \code{\link[spdep]{moran.test}}).}

}
\author{
Philipp Otto \email{philipp.otto@glasgow.ac.uk}
}
\note{
For further details about the Moran's I test see \code{\link[spdep]{moran.test}}.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
The model fitting functions \code{\link{qml.spARCH}} and \code{\link{qml.SARspARCH}}. Function \code{\link[stats]{coef}} will extract the matrix of coefficients with standard errors, t-statistics and p-values.
}
\examples{
require("spdep")

# directional spatial ARCH process (W is triangular, 1:1 origin)

rho <- 0.5
alpha <- 1
d <- 5
n <- d^2
nblist <- cell2nb(d, d, type = "queen")
W <- nb2mat(nblist)
W[lower.tri(W)] <- 0
y <- sim.spARCH(n = n, rho = rho, alpha = alpha, W = W, type = "spARCH")

out <- qml.spARCH(y ~ 0, W = W, type = "spARCH")

summary(out)
}
\keyword{spARCH}% use one of  RShowDoc("KEYWORDS")
