% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_bj.R
\name{span_bj}
\alias{span_bj}
\title{Britten–Jones Tangency-Portfolio Spanning Test (1999)}
\usage{
span_bj(R1, R2)
}
\arguments{
\item{R1}{Numeric matrix of benchmark returns, dimension \eqn{T \times K}.}

\item{R2}{Numeric matrix of test-asset returns, dimension \eqn{T \times N}.}
}
\value{
A named list with components:
\describe{
  \item{\code{pval}}{P-value for the \eqn{F}-statistic under the null.}
  \item{\code{stat}}{Britten–Jones \eqn{F}-statistic.}
  \item{\code{H0}}{Null hypothesis description, \code{"tangency portfolio spanned by benchmark"}.}
}
}
\description{
Tests whether the tangency (maximum Sharpe) portfolio of the augmented
universe (benchmarks + test assets) is spanned by the benchmark assets
alone. Following Britten–Jones (1999), the statistic arises from a
regression of a constant on return differences and yields an \eqn{F}
test of the tangency-spanning restriction.
}
\details{
With \code{X} formed from pairwise differences, the reference distribution is
\eqn{F_{N,\ T - ncol(X)}}; here \code{ncol(X)} = \eqn{K + N - 1}.
Finite-sample feasibility requires \code{T - (K + N - 1) >= 1}.
}
\examples{
set.seed(321)
R1 <- matrix(rnorm(300), 100, 3)  # benchmarks: T=100, K=3
R2 <- matrix(rnorm(200), 100, 2)  # tests:      T=100, N=2
out <- span_bj(R1, R2)
out$stat; out$pval; out$H0

}
\references{
\insertRef{BrittenJones1999}{spantest} \cr
}
\seealso{
Other Alpha Spanning Tests: 
\code{\link{span_f1}()},
\code{\link{span_gl_a}()},
\code{\link{span_grs}()},
\code{\link{span_py}()}
}
\concept{Alpha Spanning Tests}
