% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spareg.R
\name{get_model}
\alias{get_model}
\title{Extractor of Specific Model from \code{'spar'} and \code{'spar.cv'} Object}
\usage{
get_model(object, opt_par = c("best", "1se"))
}
\arguments{
\item{object}{A fitted '\code{spar}' or '\code{spar.cv}'  model}

\item{opt_par}{One of "best", "1se"}
}
\value{
A '\code{spar}'  or '\code{spar.cv}'  object where the beta and intercept elements are
the ones which correspond to the best or the 1se model.
}
\description{
Extractor of Specific Model from \code{'spar'} and \code{'spar.cv'} Object
}
\examples{
example_data <- simulate_spareg_data(n = 100, p = 400, ntest = 100)
spar_res <- spar(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, screencoef = screen_cor(),
  rp = rp_gaussian(), nummods=c(5, 10))
best_model <- get_model(spar_res, opt_par = "best")
\donttest{
spar_cv <- spar.cv(example_data$x, example_data$y,
  screencoef = screen_cor(),
  rp = rp_gaussian(), nummods = c(5, 10), nfolds = 4L)
best_model_cv <- get_model(spar_cv, opt_par = "best")
onese_model_cv <- get_model(spar_cv, opt_par = "1se")
}
}
