% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{plot.sparseDFM}
\alias{plot.sparseDFM}
\title{sparseDFM Plot Outputs}
\usage{
\method{plot}{sparseDFM}(
  x,
  type = "factor",
  which.factors = 1:(dim(x$state$factors)[2]),
  scale.factors = TRUE,
  which.series = 1:(dim(x$params$Lambda)[1]),
  loading.factor = 1,
  series.col = "grey",
  factor.col = "black",
  factor.lwd = 2,
  factor.lab = NULL,
  use.series.names = FALSE,
  series.lab = NULL,
  series.labpos = NULL,
  colorkey = TRUE,
  col.regions = NULL,
  group.names = NULL,
  group.cols = NULL,
  group.legend = TRUE,
  residual.type = "boxplot",
  scatter.series = 1,
  min.bic.col = "red",
  alpha_index = "best",
  ...
)
}
\arguments{
\item{x}{an object of class 'sparseDFM'.}

\item{type}{character. The type of plot: \code{"factor"}, \code{"loading.heatmap"}, \code{"loading.lineplot"}, \code{"loading.grouplineplot"} or \code{"residual"}. Default is \code{"factor"}.}

\item{which.factors}{numeric vector of integers representing which factors should be plotted in \code{"factor"} and \code{"loading.heatmap"}. Default is \code{which.factors}=\code{1:(dim(x$state$factors)[2])}, plotting them all. Accepts a single integer if just one factor required.}

\item{scale.factors}{logical. Standardize the factor estimates when plotting in \code{"factor"}. Default is \code{TRUE}.}

\item{which.series}{numeric vector of integers representing which series should be plotted in \code{"loading.heatmap"}, \code{"loading.lineplot"}, \code{"loading.grouplineplot"} and \code{"residual"}. Default is \code{which.series} = \code{1:(dim(x$params$Lambda)[1])}, plotting them all.}

\item{loading.factor}{integer. The factor to use in \code{"loading.lineplot"} and \code{"loading.grouplineplot"}. Default is 1.}

\item{series.col}{character. The colour of the background series plotted in \code{"factor"}. Default is \code{series.col} = \code{"grey"}.}

\item{factor.col}{character. The colour of the factor estimate line in \code{"factor"}. Default is \code{factor.col} = \code{"black"}.}

\item{factor.lwd}{integer. The line width of the factor estimate line in \code{"factor"}. Default is \code{factor.lwd} = 2.}

\item{factor.lab}{vector of characters to label each factor in \code{"loading.heatmap"}. Default is \code{NULL} for standard labeling.}

\item{use.series.names}{logical. Set to TRUE if plot should display series names in the data matrix X. Default is \code{FALSE} for numbered series.}

\item{series.lab}{vector of characters to label each data series in \code{"loading.heatmap"}. Default is \code{NULL} for standard labeling.}

\item{series.labpos}{numeric vector of integers representing which series are labeled by \code{series.lab}. Default is \code{NULL} for standard labeling.}

\item{colorkey}{logical. Display the colour key of the heatmap in \code{"loading.heatmap"}. Default is \code{TRUE}.}

\item{col.regions}{vector of gradually varying colors for \code{"loading.heatmap"}, see levelplot package. Default is \code{NULL} for standard colours.}

\item{group.names}{vector of characters of the same dimension as \code{which.series} to represent the name of the group for each series in \code{"loading.grouplineplot"}.}

\item{group.cols}{vector of characters of the same dimension as the number of different groups in \code{"loading.grouplineplot"} to represent the colours of the groups.}

\item{group.legend}{logical. Display the legend. Default is \code{TRUE}.}

\item{residual.type}{character. The type of residual plot: \code{"boxplot"} or \code{"scatterplot"}. Default is \code{"boxplot"}.}

\item{scatter.series}{integer. The series to plot when \code{residual.type} = \code{"scatterplot"}. Default is series 1.}

\item{min.bic.col}{character. Colour for the best \eqn{\alpha}{\alpha} point. Default is \code{'red'}.}

\item{alpha_index}{Choose which L1 penalty parameter to display the results for. Default is 'best'. Otherwise, input a number between 1:length(alpha_grid) that indicates the required alpha parameter.}

\item{\dots}{for \code{plot.sparseDFM}. Further plot arguments.}
}
\value{
Plots for the output of sparseDFM().
}
\description{
Make plots for the output of sparseDFM(). Options include:
\itemize{
\item \code{factor} - plot factor estimate series on top of the original standardized stationary data
\item \code{loading.heatmap} - make a heatmap of the loadings matrix
\item \code{loading.lineplot} - make a lineplot of variable loadings for a given factor
\item \code{loading.grouplineplot} - separate variable groups into colours for better visualisation
\item \code{residual} - boxplot or scatterplot of residuals
\item \code{lasso.bic} - BIC values for the LASSO tuning parameter
\item \code{em.convergence} - log-likelihood convergence of EM iterations
}
}
