% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cv_multiple}
\alias{cv_multiple}
\alias{cv_transfer}
\title{Model comparison}
\usage{
cv_multiple(
  y,
  X,
  family,
  alpha = 1,
  nfolds = 10,
  method = c("wrap_separate", "wrap_mgaussian", "sparselink", "wrap_spls"),
  alpha.init = 0.95,
  type = "exp",
  cands = NULL
)

cv_transfer(
  y,
  X,
  family,
  alpha = 1,
  nfolds = 10,
  method = c("wrap_separate", "wrap_glmtrans", "sparselink", "wrap_xrnet"),
  alpha.init = 0.95,
  type = "exp",
  cands = NULL
)
}
\arguments{
\item{y}{\eqn{n \times q} matrix (multi-task learning)
or list of \eqn{n_k}-dimensional vectors (transfer learning)}

\item{family}{character \code{"gaussian"} or \code{"binomial"}}

\item{alpha}{elastic net mixing parameter of final regressions,
default: 1 (lasso)}

\item{nfolds}{number of internal cross-validation folds,
default: 10 (10-fold cross-validation)}

\item{alpha.init}{elastic net mixing parameter for initial regressions,
default: 0.95 (lasso-like elastic net)}

\item{type}{default \code{"exp"} scales weights with
\eqn{w_{ext}^{v_{ext}}+w_{int}^{v_{int}}}
(see internal function \link{construct_penfacs} for details)}

\item{cands}{candidate values for both scaling parameters,
default: \code{NULL} (\{0, 0.2, 0.4, 0.6, 0.8, 1\})}
}
\value{
Returns a list with slots \code{deviance},
\code{auc} (only relevant if \code{family="binomial"}),
and \code{refit}.
}
\description{
Compares predictive methods for multi-task learning (\code{cv_multiple}) or
transfer learning (\code{cv_transfer}) by \eqn{k}-fold cross-validation.
}
\examples{
#--- multi-task learning ---
\donttest{
family <- "gaussian"
data <- sim_data_multi(family=family)
metric <- cv_multiple(y=data$y_train,X=data$X_train,family=family)
metric$deviance}

#--- transfer learning ---
\donttest{
family <- "gaussian"
data <- sim_data_trans(family=family)
metric <- cv_transfer(y=data$y_train,X=data$X_train,family=family)
metric$deviance}

}
\keyword{internal}
