% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sparselink}
\alias{sparselink}
\title{Sparse regression for related problems}
\usage{
sparselink(
  x,
  y,
  family,
  alpha.init = 0.95,
  alpha = 1,
  type = "exp",
  nfolds = 10,
  cands = NULL
)
}
\arguments{
\item{x}{\eqn{n \times p} matrix (multi-task learning) 
or list of \eqn{n_k \times p} matrices (transfer learning)}

\item{y}{\eqn{n \times q} matrix (multi-task learning)
or list of \eqn{n_k}-dimensional vectors (transfer learning)}

\item{family}{character \code{"gaussian"} or \code{"binomial"}}

\item{alpha.init}{elastic net mixing parameter for initial regressions,
default: 0.95 (lasso-like elastic net)}

\item{alpha}{elastic net mixing parameter of final regressions,
default: 1 (lasso)}

\item{type}{default \code{"exp"} scales weights with
\eqn{w_{ext}^{v_{ext}}+w_{int}^{v_{int}}}
(see internal function \link{construct_penfacs} for details)}

\item{nfolds}{number of internal cross-validation folds,
default: 10 (10-fold cross-validation)}

\item{cands}{candidate values for both scaling parameters,
default: \code{NULL} (\{0, 0.2, 0.4, 0.6, 0.8, 1\})}
}
\value{
Returns an object of class \code{sparselink}, a list with multiple slots:
\itemize{
\item Stage 1 regressions (before sharing information):
Slot \code{glm.one} contains \eqn{q} objects of type
\code{cv.glmnet} (one for each problem).
\item Candidate scaling parameters (exponents):
Slot \code{weight} contains
a data frame with \eqn{n} combinations of exponents for the external (source)
and internal (target) weights
\item Stage 2 regressions (after sharing information):
Slot \code{glm.two} contains \eqn{q} lists (one for each problem)
of \eqn{n} objects of type \code{cv.glmnet}
(one for each combination of exponents).
\item Optimal regularisation parameters: Slot \code{lambda.min}
contains the cross-validated regularisation parameters for the stage 2
regressions.
\item Optimal scaling parameters: Slots \code{weight.ind} and
\code{weight.min} indicate or contain the cross-validated scaling parameters.
}
}
\description{
Estimates sparse regression models (i.e., performing feature selection)
in multi-task learning or transfer learning.
Multi-task learning involves multiple targets,
and transfer learning involves multiple datasets.
}
\examples{
#--- multi-task learning ---
n <- 100
p <- 200
q <- 3
\dontshow{n <- 10; p <- 5; q <- 2}
family <- "gaussian"
x <- matrix(data=rnorm(n=n*p),nrow=n,ncol=p)
y <- matrix(data=rnorm(n*q),nrow=n,ncol=q)
object <- sparselink(x=x,y=y,family=family)

#--- transfer learning ---
n <- c(100,50)
p <- 200
\dontshow{n <- c(10,10); p <- 5}
x <- lapply(X=n,function(x) matrix(data=stats::rnorm(n*p),nrow=x,ncol=p))
y <- lapply(X=n,function(x) stats::rnorm(x))
family <- "gaussian"
object <- sparselink(x=x,y=y,family=family)

}
\references{
\href{https://orcid.org/0000-0001-6498-4801}{Armin Rauschenberger},
\href{https://orcid.org/0000-0003-3443-0298}{Petr N. Nazarov}, and
\href{https://orcid.org/0000-0003-3977-7469}{Enrico Glaab}
(2025).
"Estimating sparse regression models in multi-task learning and transfer learning through adaptive penalisation".
\emph{Under revision}. \url{https://hdl.handle.net/10993/63425}
}
\seealso{
Use \code{\link[=coef.sparselink]{coef}} to extract coefficients
and \code{\link[=predict.sparselink]{predict}} to make predictions.
}
