% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fuse_data}
\alias{fuse_data}
\title{Data fusion}
\usage{
fuse_data(x, y = NULL, foldid = NULL)
}
\arguments{
\item{x}{list of \eqn{q} matrices, with \eqn{n_1,\ldots,n_q} rows
and with \eqn{p} columns}

\item{y}{list of \eqn{q} vectors, of length \eqn{n_1,\ldots,n_q},
or \code{NULL} (default)}

\item{foldid}{list of \eqn{q} vectors, of length \eqn{n_1,\ldots,n_q},
or \code{NULL} (default)}
}
\value{
Returns a list with the concatenated feature matrices in slot \code{x} (\eqn{(\sum_i^q n_i) \times p} matrix), the concatenated target vectors in slot \code{y} (vector of length \eqn{(\sum_i^q n_i)}), and the indices of the problems in slot \code{index} (vector of length \eqn{(\sum_i^q n_i)} with entries \eqn{1,\ldots,q}).
}
\description{
Data fusion
}
\examples{
data <- sim_data_trans()
sapply(X=data$y_train,FUN=length)
sapply(X=data$X_train,FUN=dim)
fuse <- fuse_data(x=data$X_train,y=data$y_train)
length(fuse$y)
dim(fuse$x)
table(fuse$index)

}
\keyword{internal}
