% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot_weight}
\alias{plot_weight}
\title{Visualise metric that depends on two parameters}
\usage{
plot_weight(x, y)
}
\arguments{
\item{x}{list with slots source and target}

\item{y}{numeric vector}
}
\value{
Returns \code{NULL}. Generates a plot.
}
\description{
Displays values in \code{y} in a grey scale (white=lowest, black=highest),
for different combinations of the two variables in \code{x}.
The lowest value is indicated by a red cross,
and the lowest value on the diagonal is indicated by a red circle.
}
\examples{
values <- seq(from=0,to=1,by=0.2)
x <- expand.grid(source=values,target=values)
y <- stats::rexp(n=length(values)*length(values))
plot_weight(x=x,y=y)

}
\keyword{internal}
