% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{traintest}
\alias{traintest}
\title{Train and test model}
\usage{
traintest(
  y_train,
  X_train,
  y_test = NULL,
  X_test = NULL,
  family = "gaussian",
  alpha = 1,
  method = c("wrap_empty", "wrap_separate", "sparselink"),
  alpha.init = 0.95,
  type = "exp",
  cands = NULL
)
}
\arguments{
\item{y_train}{target of training samples:
\eqn{n \times q} matrix (multi-task learning)
or list of \eqn{q} vectors of length \eqn{n_1,\ldots,n_q} (transfer learning)}

\item{X_train}{features of training samples:
\eqn{n \times p} matrix (multi-task learning)
or list of \eqn{q} matrices of dimensions
\eqn{n_1 \times p,\ldots,n_q \times p} (transfer learning)}

\item{y_test}{target of testing samples:
\eqn{m \times p} matrix (multi-task learning)
or list of \eqn{q} vectors of length \eqn{m_1,\ldots,m_q} (transfer learning)}

\item{X_test}{features of testing samples:
\eqn{m \times p} matrix (multi-task learning) or
list of \eqn{q} matrices of dimensions
\eqn{m_1 \times p,\ldots,m_q \times p} (transfer learning)}

\item{family}{character \code{"gaussian"} or \code{"binomial"}}

\item{alpha}{elastic net mixing parameter of final regressions,
default: 1 (lasso)}

\item{alpha.init}{elastic net mixing parameter for initial regressions,
default: 0.95 (lasso-like elastic net)}

\item{type}{default \code{"exp"} scales weights with
\eqn{w_{ext}^{v_{ext}}+w_{int}^{v_{int}}}
(see internal function \link{construct_penfacs} for details)}

\item{cands}{candidate values for both scaling parameters,
default: \code{NULL} (\{0, 0.2, 0.4, 0.6, 0.8, 1\})}
}
\value{
Returns a list with the computation time in slot \code{time}, the out-of-sample deviance in slot \code{deviance}, the out-of-sample ROC-AUC in slot \code{auc}, the coefficients in slot \code{coef}, the predicted value in slot \code{y_hat}, and the optimal hyperparameters in slot \code{hyperpar}.
}
\description{
Trains and tests prediction models
}
\examples{
#--- multi-task learning ---
\donttest{
family <- "gaussian"
data <- sim_data_multi(family=family)
result <- traintest(data$y_train,data$X_train,family=family)}

#--- transfer learning ---
\donttest{
family <- "gaussian"
data <- sim_data_trans(family=family)
result <- traintest(data$y_train,data$X_train,family=family)}

}
\keyword{internal}
