% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sieve.R
\name{sieve}
\alias{sieve}
\title{Sieve raster data}
\usage{
sieve(x, a, unit = c("m", "km", "ha"))
}
\arguments{
\item{x}{An integer terra SpatRaster}

\item{a}{Query area to remove}

\item{unit}{The unit to use for area query options are c("m", "km", "ha")}
}
\value{
A terra SpatRaster with cells < a set to NA
}
\description{
Removes contiguous cells < specified query area
}
\details{
A sieve can be used to establish a minimal mapping unit where
contiguous cells < specified query area are set to NA. These NA
values can then be filled using focal (majority, median, mean)
}
\examples{
\donttest{
library(terra)
elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))
m <- matrix(c(100,200,1,200,300,2,300,400,3,400,
       500,4, 500,600,5), ncol=3, byrow=TRUE)
  x <- classify(elev, m)

# Sieve to a MMU of 60km
sv <- spatialEco::sieve(x, a = 60, unit = "km")
  plot(c(x, sv))
} 
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
