% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predictions.R
\name{get_predictions}
\alias{get_predictions}
\title{Extract fitted predictions from model}
\usage{
get_predictions(model)
}
\arguments{
\item{model}{Model object from \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
Numeric vector of fitted predictions with length equal to the number of training observations. For \code{\link[=rf_repeat]{rf_repeat()}} models, returns the median prediction across repetitions.
}
\description{
Extracts fitted (in-sample) predictions from models fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.
}
\details{
This function returns fitted predictions for the training data used to build the model, not predictions for new data. For out-of-sample predictions on new data use \code{\link[stats:predict]{stats::predict()}}.
}
\examples{
data(plants_rf)

# Extract fitted predictions
predictions <- get_predictions(plants_rf)
head(predictions)

# Check length matches number of observations
length(predictions)

# Compare with observed values to assess fit
# (observed values would be in original data)

}
\seealso{
\code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, \code{\link[=rf_spatial]{rf_spatial()}}, \code{\link[=get_residuals]{get_residuals()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_residuals}()},
\code{\link{get_response_curves}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_importance}()},
\code{\link{print_moran}()},
\code{\link{print_performance}()}
}
\concept{model_info}
