% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_choropleth.R
\name{choropleth}
\alias{choropleth}
\title{Create choropleth map}
\usage{
choropleth(
  sf_object,
  value = "output",
  id_name = "areaname",
  mode = "plot",
  n = 7,
  legend_title = "Clustering",
  palette = "viridis"
)
}
\arguments{
\item{sf_object}{An object of class \code{sf}.}

\item{value}{A string giving the name of the column used to shade the
polygons.}

\item{id_name}{A string giving the name of the column containing polygon IDs
(used for tooltips in interactive mode).}

\item{mode}{A string indicating whether to create a static map
(\code{"plot"}, default) or an interactive map (\code{"view"}).}

\item{n}{Integer; number of clusters. Default is \code{7}.}

\item{legend_title}{A string giving the legend title.}

\item{palette}{A palette name or vector of colors. See
\code{tmaptools::palette_explorer()} for available palettes.
Prefix the name with \code{"-"} to reverse the order. Default is
\code{"viridis"}.}
}
\value{
A \code{tmap} object (static or interactive, depending on
\code{mode}).
}
\description{
Creates a choropleth map from an `sf` object, typically produced
by \code{points_to_polygon()}. Polygons are shaded according to values in a
specified column, with clustering based on the Fisher–Jenks algorithm. This
method minimizes within-class variance and maximizes between-class variance,
making it a common choice for choropleth maps.
}
\details{
The function uses the Fisher–Jenks algorithm
(\code{style = "fisher"}) to classify values into \code{n} groups.
}
\examples{
test <- points_to_polygon(nl_provincie, insurance, sum(amount, na.rm = TRUE))
choropleth(test)
choropleth(test, id_name = "areaname", mode = "view")

}
\author{
Martin Haringa
}
