% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsw_sews.R
\name{lsw_sews}
\alias{lsw_sews}
\alias{raw_patch_radii_skewness}
\alias{raw_lsw_aicw}
\title{Indicators based on the LSW distribution}
\usage{
lsw_sews(mat, wrap = FALSE)

raw_patch_radii_skewness(mat, wrap = FALSE)

raw_lsw_aicw(mat, wrap = FALSE)
}
\arguments{
\item{mat}{A logical matrix (\code{TRUE}/\code{FALSE} values) or a list of such
matrices}

\item{wrap}{Determines whether patches are considered to wrap around the 
matrix when reaching on of its edges}
}
\value{
\code{lsw_sews} returns an object of class \code{simple_sews_single}
  (a list) if \code{mat} is a single matrix or an object of class 
  \code{simple_sews_list} if \code{mat} is a list. You probably want to use some  
  of the methods written for these complicated objects instead of extracting 
  values directly (they are displayed using \code{print(<object>)}).
}
\description{
LSW indicators for systems with density-dependent aggregation
}
\details{
In systems where a mobile resource or consumer can be fixed in space by a sessile 
species, specific patterns are expected to appear. Such systems can include situations 
where nutrients available in the environmeent are fixed by a sessile species (e.g. 
seagrasses or corals), or where the behavior of herbivores is altered to restrict 
them to certain areas (see full theoretical background in Siteur et al. 2023). 

In those systems, as environmental conditions change and the global density of 
the sessile species decreases, its spatial structure is expected to change. The area 
of patches of the sessile species (as measured by their radii, which assumes circular
patches), is expected to go from a log-normal to a  Lifshitz–Slyozov–Wagner (LSW)
distribution. Thus, measuring how close the observed distribution of radii are to 
those two candidate distributions can constitute an indicator of ecosystem 
degradation. 

This function measures this through the relative support based on AIC for the two 
distributions (equal to 1 when the empirical distribution is best-approximated by an 
LSW, and 0 when it is a log-normal distribution (\code{\link{dlnorm}}), and the 
skewness of the observed patch radii, which should approach a value around -0.92 as
conditions worsen.
}
\examples{

data(dda)
data(dda.pars)

# Compute all indicators at once (skewness and relative AIC support)
indics <- lsw_sews(dda)
plot(indics, along = dda.pars[ ,"tau"]) 

# Compute individual indicators 

# Skewness of the distribution of patch radii
radii_skewness <- compute_indicator(dda, raw_patch_radii_skewness)
plot(radii_skewness, along = dda.pars[ ,"tau"])

# Aic weight of LSW distribution relative to a lognormal distribution. tau here 
# represents the density at equilibrium in Siteur et al's model (2023)
lsw_aicw <- compute_indicator(dda, raw_lsw_aicw)
plot(lsw_aicw, along = 1 - dda.pars[ ,"tau"])

}
\references{
Siteur, Koen, Quan-Xing Liu, Vivi Rottschäfer, Tjisse van der Heide, Max Rietkerk, 
Arjen Doelman, Christoffer Boström, and Johan van de Koppel. 2023. 
"Phase-Separation Physics Underlies New Theory for the Resilience of Patchy 
Ecosystems." Proceedings of the National Academy of Sciences 120 (2): e2202683120.
https://doi.org/10.1073/pnas.2202683120.
}
\seealso{
\code{\link{dLSW}}, \code{\link{dda}},
  \code{\link{raw_patch_radii_skewness}}, \code{\link{raw_lsw_aicw}}
}
\author{
This code has received contributions from Koen Siteur
}
