% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findFirstStudyRegionPoint.R
\name{findRandomHaltonIndex}
\alias{findRandomHaltonIndex}
\title{Randomly generates a point in the study region and maps it to the Halton Sequence.}
\usage{
findRandomHaltonIndex(shapefile, bb, n = 1, uplim = 10^6, verbose = FALSE)
}
\arguments{
\item{shapefile}{Shape file as a polygon (sp or sf) of the study area(s).}

\item{bb}{Bounding box which defines the sample. A bounding box must be
supplied and may not necessarily be the bounding box of the provided shape.}

\item{n}{Number of seeds to produce.}

\item{uplim}{Limit of how accurate to be mapping point to Halton sequence. Not advised larger than 10^15.}

\item{verbose}{Boolean if you want to see any output printed to screen. Helpful if taking a
long time. Default is FALSE i.e. no informational messages are displayed.}
}
\value{
A matrix with n rows and 2 columns.
}
\description{
This function uses \code{sf::st_sample()} to generate a random point in the study region.
it then maps that point to the Halton Sequence to ensure that the random starting point is within the region.
this function is used internally, and is called by a wrapper \code{findBASSeed()}.
}
\author{
Paul van Dam-Bates and Blair Robertson
}
\keyword{internal}
