% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shewhart.R
\docType{class}
\name{SPCShew-class}
\alias{SPCShew-class}
\title{Shewhart charts.}
\description{
Shewhart charts.
}
\section{Slots}{

\describe{
\item{\code{twosided}}{TRUE if a two-sided chart should be used. Default FALSE.}
}}
\examples{
X<-rnorm(100);
##calibrate to ARL 100
chartShew <- new("SPCShew",model=SPCModelNormal(),twosided=TRUE)
\dontrun{
SPCproperty(data=X,nrep=500,
            property="calARL",chart=chartShew,params=list(target=100),
            covprob=c(0.7,0.9))

chartShewOneSided <- new("SPCShew",model=SPCModelNormal(),twosided=FALSE)
SPCproperty(data=X,nrep=500,
            property="calARL",chart=chartShewOneSided,
            params=list(target=100),covprob=c(0.7,0.9))

##calibrate to a hitting probability of 0.01 in 100 steps
SPCproperty(data=X,nrep=500,
            property="calhitprob",
            chart=chartShew,params=list(target=0.01,nsteps=100))
SPCproperty(data=X,nrep=500,
            property="calhitprob",chart=chartShewOneSided,params=list(target=0.01,nsteps=100))

## work out  for ARL for a fixed threshold of 4
SPCproperty(data=X,nrep=500,
            property="ARL",chart=chartShew,params=list(threshold=4))
SPCproperty(data=X,nrep=500,
            property="ARL",chart=chartShewOneSided,
            params=list(threshold=4))

SPCproperty(data=X,nrep=500,
            property="hitprob",chart=chartShew,params=list(nsteps=100,threshold=4))

SPCproperty(data=X,nrep=500,
            property="hitprob",chart=chartShewOneSided,params=list(nsteps=100,threshold=4))
}

X<-rnorm(100)
chartShew <- new("SPCShew",model=SPCModelNormal())
\dontrun{
SPCproperty(data=X,nrep=500,
            property="calARL", chart=chartShew,
            params=list(target=1000))
SPCproperty(data=X,nrep=500,
            property="calhitprob",chart=chartShew,
            params=list(target=0.01,nsteps=100))
SPCproperty(data=X,nrep=10,chart=chartShew,
            property="ARL",params=list(threshold=3))
SPCproperty(data=X,nrep=500,
            property="hitprob",
            chart=chartShew,params=list(nsteps=100,threshold=4))
}
}

